package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VimpresionDocDao;
import com.ejie.ab04b.model.VimpresionDoc;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VimpresionDocServiceImpl generated by UDA, 05-sep-2017 8:53:44.
 * 
 * @author UDA
 */

@Service(value = "vimpresionDocService")
public class VimpresionDocServiceImpl implements VimpresionDocService {

	@Autowired
	private VimpresionDocDao vimpresionDocDao;

	/**
	 * Inserts a single row in the VimpresionDoc table.
	 * 
	 *  vimpresionDoc
	 *            VimpresionDoc
	 *  VimpresionDoc
	 *
	 * @param vimpresionDoc the vimpresion doc
	 * @return the vimpresion doc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VimpresionDoc add(VimpresionDoc vimpresionDoc) {
		return this.vimpresionDocDao.add(vimpresionDoc);
	}

	/**
	 * Updates a single row in the VimpresionDoc table.
	 * 
	 *  vimpresionDoc
	 *            VimpresionDoc
	 *  VimpresionDoc
	 *
	 * @param vimpresionDoc the vimpresion doc
	 * @return the vimpresion doc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VimpresionDoc update(VimpresionDoc vimpresionDoc) {
		return this.vimpresionDocDao.update(vimpresionDoc);
	}

	/**
	 * Finds a single row in the VimpresionDoc table.
	 * 
	 *  vimpresionDoc
	 *            VimpresionDoc
	 *  VimpresionDoc
	 *
	 * @param vimpresionDoc the vimpresion doc
	 * @return the vimpresion doc
	 */
	public VimpresionDoc find(VimpresionDoc vimpresionDoc) {
		return (VimpresionDoc) this.vimpresionDocDao.find(vimpresionDoc);
	}

	/**
	 * Deletes a single row in the VimpresionDoc table.
	 * 
	 *  vimpresionDoc
	 *            VimpresionDoc
	 *
	 * @param vimpresionDoc the vimpresion doc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VimpresionDoc vimpresionDoc) {
		this.vimpresionDocDao.remove(vimpresionDoc);
	}

	/**
	 * Finds a list of rows in the VimpresionDoc table.
	 * 
	 *  vimpresionDoc
	 *            VimpresionDoc
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VimpresionDoc>
	 *
	 * @param vimpresionDoc the vimpresion doc
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VimpresionDoc> findAll(VimpresionDoc vimpresionDoc,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VimpresionDoc>) this.vimpresionDocDao.findAll(
				vimpresionDoc, jqGridRequestDto);
	}

	/**
	 * Finds rows in the VimpresionDoc table using like.
	 * 
	 *  vimpresionDoc
	 *            VimpresionDoc
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VimpresionDoc>
	 *
	 * @param vimpresionDoc the vimpresion doc
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VimpresionDoc> findAllLike(VimpresionDoc vimpresionDoc,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VimpresionDoc>) this.vimpresionDocDao.findAllLike(
				vimpresionDoc, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VimpresionDoc table.
	 * 
	 *  filterVimpresionDoc
	 *            VimpresionDoc
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVimpresionDoc the filter vimpresion doc
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VimpresionDoc filterVimpresionDoc,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.vimpresionDocDao.removeMultiple(filterVimpresionDoc,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the VimpresionDoc table.
	 * 
	 *  filterVimpresionDoc
	 *            VimpresionDoc
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VimpresionDoc>
	 *
	 * @param filterVimpresionDoc the filter vimpresion doc
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VimpresionDoc> filter(
			VimpresionDoc filterVimpresionDoc,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VimpresionDoc> listaVimpresionDoc = this.vimpresionDocDao.findAll(
				filterVimpresionDoc, jqGridRequestDto);
		Long recordNum = this.vimpresionDocDao
				.findAllCount(filterVimpresionDoc != null ? filterVimpresionDoc
						: new VimpresionDoc());
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VimpresionDoc>> reorderSelection = this.vimpresionDocDao
					.reorderSelection(filterVimpresionDoc, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VimpresionDoc>(jqGridRequestDto,
					recordNum, listaVimpresionDoc, reorderSelection);
		}
		return new JQGridResponseDto<VimpresionDoc>(jqGridRequestDto,
				recordNum, listaVimpresionDoc);
	}

	/**
	 * Searches rows in the VimpresionDoc table.
	 * 
	 *  filterVimpresionDoc
	 *            VimpresionDoc
	 *  searchVimpresionDoc
	 *            VimpresionDoc
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VimpresionDoc>>
	 *
	 * @param filterVimpresionDoc the filter vimpresion doc
	 * @param searchVimpresionDoc the search vimpresion doc
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VimpresionDoc>> search(
			VimpresionDoc filterVimpresionDoc,
			VimpresionDoc searchVimpresionDoc,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vimpresionDocDao.search(filterVimpresionDoc,
				searchVimpresionDoc, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VimpresionDoc table.
	 * 
	 *  filterVimpresionDoc
	 *            VimpresionDoc
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVimpresionDoc the filter vimpresion doc
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VimpresionDoc filterVimpresionDoc,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vimpresionDocDao.reorderSelection(filterVimpresionDoc,
				jqGridRequestDto, startsWith);
	}

}
